<?php

namespace Database\Factories;

use App\Models\SocialAggregate;
use Illuminate\Database\Eloquent\Factories\Factory;

class SocialAggregateFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = SocialAggregate::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'user_id' => null,
            'brand_id' => null,
            'tenant_id' => null,
            'provider' => null,
            'key' => $this->faker->word,
            'value' => $this->faker->randomNumber(),
            'computed_at' => $this->faker->dateTimeBetween('-1 month', 'now'),
        ];
    }
    
    /**
     * Indicate that the aggregate belongs to a brand.
     *
     * @param int $brandId
     * @param int $tenantId
     * @return static
     */
    public function forBrand($brandId, $tenantId)
    {
        return $this->state(function (array $attributes) use ($brandId, $tenantId) {
            return [
                'user_id' => null,
                'brand_id' => $brandId,
                'tenant_id' => $tenantId,
            ];
        });
    }
}