<?php

namespace Database\Factories;

use App\Models\ProposalTransition;
use App\Models\Proposal;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProposalTransitionFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = ProposalTransition::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'proposal_id' => Proposal::factory(),
            'from_status' => $this->faker->randomElement(['draft', 'sent', 'accepted', 'rejected', 'contract_sent', 'contract_signed', 'payment_made', 'delivered']),
            'to_status' => $this->faker->randomElement(['draft', 'sent', 'accepted', 'rejected', 'contract_sent', 'contract_signed', 'payment_made', 'delivered']),
            'changed_by' => User::factory(),
            'notes' => $this->faker->sentence,
        ];
    }
}