<?php

namespace Database\Factories;

use App\Models\Message;
use App\Models\User;
use App\Models\MessageThread;
use Illuminate\Database\Eloquent\Factories\Factory;

class MessageFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Message::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'sender_id' => User::factory(),
            'recipient_id' => User::factory(),
            'subject' => $this->faker->sentence,
            'message' => $this->faker->paragraph,
            'attachment_path' => null,
            'is_read' => $this->faker->boolean,
            'read_at' => $this->faker->optional()->dateTime(),
            'parent_id' => null,
            'thread_id' => MessageThread::factory(),
        ];
    }
}