<?php

namespace Database\Factories;

use App\Models\Brand;
use App\Models\Tenant;
use Illuminate\Database\Eloquent\Factories\Factory;

class BrandFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Brand::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
   {
       // Get existing tenant or create new one if none exist
       $tenant = Tenant::inRandomOrder()->first() ?? Tenant::factory()->create();
       
       return [
           'tenant_id' => $tenant->id,
           'name' => $this->faker->company,
           'slug' => $this->faker->slug,
           'settings' => [],
       ];
   }
}