#!/bin/bash

# Reel Processing Callback Examples
# These examples show how to simulate callbacks from the reel processing microservice

# Example 1: Successful completion callback
echo "=== Successful Completion Callback ==="
curl -X POST http://localhost:8000/api/reels/callback \
  -H "Content-Type: application/json" \
  -H "X-Processor-Signature: $(echo -n '{"job_id":"job-12345","status":"completed","result_url":"http://example.com/result.mp4","duration":30}' | openssl dgst -sha256 -hmac "reel-secret-key" | sed 's/.* //')" \
  -d '{
    "job_id": "job-12345",
    "status": "completed",
    "result_url": "http://example.com/result.mp4",
    "duration": 30
  }'

echo -e "\n\n"

# Example 2: Failed processing callback
echo "=== Failed Processing Callback ==="
curl -X POST http://localhost:8000/api/reels/callback \
  -H "Content-Type: application/json" \
  -H "X-Processor-Signature: $(echo -n '{"job_id":"job-67890","status":"failed","error":"Video processing failed due to unsupported format"}' | openssl dgst -sha256 -hmac "reel-secret-key" | sed 's/.* //')" \
  -d '{
    "job_id": "job-67890",
    "status": "failed",
    "error": "Video processing failed due to unsupported format"
  }'

echo -e "\n\n"

# Example 3: Invalid signature (should be rejected)
echo "=== Invalid Signature Callback ==="
curl -X POST http://localhost:8000/api/reels/callback \
  -H "Content-Type: application/json" \
  -H "X-Processor-Signature: invalid-signature" \
  -d '{
    "job_id": "job-invalid",
    "status": "completed",
    "result_url": "http://example.com/invalid.mp4"
  }'