<?php

namespace App\Services\Providers;

use App\Services\Providers\InstagramProvider;
use App\Services\Providers\YouTubeProvider;
use App\Services\Providers\TikTokProvider;
use App\Services\Providers\LinkedInProvider;

class ProviderFactory
{
    /**
     * Create a provider instance based on the provider name.
     *
     * @param string $provider
     * @return ReelProviderInterface|null
     */
    public static function make(string $provider): ?ReelProviderInterface
    {
        switch ($provider) {
            case 'instagram':
                return new InstagramProvider();
            case 'youtube':
                return new YouTubeProvider();
            case 'tiktok':
                return new TikTokProvider();
            case 'linkedin':
                return new LinkedInProvider();
            default:
                return null;
        }
    }
}