<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RegistrationRequest extends Model
{
    protected $fillable = [
        'name',
        'email',
        'requested_role',
        'meta',
        'status',
        'tenant_id',
        'processed_by',
    ];
    
    protected $casts = [
        'meta' => 'array',
    ];
    
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
    
    public function processedBy()
    {
        return $this->belongsTo(User::class, 'processed_by');
    }
}