<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReelInput extends Model
{
    use HasFactory;

    protected $fillable = [
        'reel_request_id',
        'source_post_id',
        'provider',
        'source_url',
        'meta',
    ];

    protected $casts = [
        'meta' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the reel request that owns this input.
     */
    public function reelRequest()
    {
        return $this->belongsTo(ReelRequest::class);
    }

    /**
     * Get the source post for this input.
     */
    public function sourcePost()
    {
        return $this->belongsTo(SocialPost::class, 'source_post_id');
    }

    /**
     * Get the signed URL for the source media.
     */
    public function getSourceUrl()
    {
        // If we have a source post, get the media URL from it
        if ($this->sourcePost && $this->sourcePost->media_url) {
            return $this->sourcePost->media_url;
        }

        // If we have a direct source URL, return it
        if ($this->source_url) {
            return $this->source_url;
        }

        return null;
    }
}