<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MarketplaceShortlist extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'brand_id',
        'name',
        'description',
        'is_public',
        'created_by',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_public' => 'boolean',
    ];

    /**
     * Get the brand that owns the shortlist.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    /**
     * Get the user that created the shortlist.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the creators in the shortlist.
     */
    public function creators()
    {
        return $this->belongsToMany(User::class, 'marketplace_shortlist_creators', 'shortlist_id', 'creator_id')
            ->withPivot(['added_by', 'notes'])
            ->withTimestamps();
    }
}