<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\View\View;

class SubscriptionController extends Controller
{
    /**
     * Display the user's subscriptions.
     */
    public function index(Request $request): View
    {
        // In a real application, you would fetch actual subscriptions from the database
        // For now, we'll create a placeholder with demo data
        $subscriptions = [
            [
                'id' => 1,
                'plan' => 'Basic Plan',
                'status' => 'active',
                'start_date' => '2025-09-01',
                'end_date' => '2025-10-01',
                'tenant_id' => $request->user()->tenant_id,
            ]
        ];

        return view('user.subscriptions', [
            'subscriptions' => $subscriptions,
        ]);
    }

    /**
     * Placeholder for subscribing to a plan.
     */
    public function subscribe(Request $request)
    {
        // In a real application, you would integrate with a payment system like Laravel Cashier
        // For now, we'll just redirect back with a success message
        
        return redirect()->route('user.subscriptions.index')->with('status', 'Subscription successful!');
    }
}