<?php

namespace App\Http\Controllers\Creator;

use App\Http\Controllers\Controller;
use App\Models\Campaign;
use Illuminate\Http\Request;

class MarketplaceController extends Controller
{
    /**
     * Display the marketplace index page
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // Get brands with their social aggregates
        $brands = \App\Models\Brand::with(['socialAggregates' => function ($q) {
            $q->whereIn('key', ['total_followers', 'total_posts']);
        }])->paginate(20);
        
        return view('creator.marketplace.index', compact('brands'));
    }
    
    /**
     * Display the opportunities page
     *
     * @return \Illuminate\Http\Response
     */
    public function opportunities()
    {
        // Get campaign invitations for this creator
        $invitations = \App\Models\CampaignCreator::where('creator_id', auth()->id())
            ->with('campaign')
            ->paginate(20);
            
        return view('creator.marketplace.opportunities', compact('invitations'));
    }
}