<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AiTask;
use Illuminate\Http\Request;

class AiTaskController extends Controller
{
    /**
     * Get AI tasks with optional filters
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $query = AiTask::query();
        
        // Filter by campaign ID
        if ($request->has('campaign_id')) {
            $query->where('payload->campaign_id', $request->campaign_id);
        }
        
        // Filter by type
        if ($request->has('type')) {
            $query->where('type', $request->type);
        }
        
        // Filter by status
        if ($request->has('status')) {
            $query->where('status', $request->status);
        }
        
        // Filter by creator ID
        if ($request->has('creator_id')) {
            $query->where('creator_id', $request->creator_id);
        }
        
        // Filter by brand ID
        if ($request->has('brand_id')) {
            $query->where('brand_id', $request->brand_id);
        }
        
        $aiTasks = $query->orderBy('created_at', 'desc')->get();
        
        return response()->json($aiTasks);
    }
}