<?php

if (!function_exists('getSignedUrl')) {
    /**
     * Generate a signed URL for a file path.
     *
     * @param string $path
     * @param int $expireMinutes
     * @return string|null
     */
    function getSignedUrl(string $path, int $expireMinutes = 300): ?string
    {
        try {
            // Check if file exists
            if (!Storage::disk('public')->exists($path)) {
                return null;
            }
            
            // Generate temporary URL
            return Storage::disk('public')->temporaryUrl(
                $path,
                now()->addMinutes($expireMinutes)
            );
        } catch (\Exception $e) {
            \Log::error('Failed to generate signed URL: ' . $e->getMessage());
            return null;
        }
    }
}

if (!function_exists('createReelStatusCheckUrl')) {
    /**
     * Create a URL to check the status of a reel.
     *
     * @param int $reelId
     * @return string
     */
    function createReelStatusCheckUrl(int $reelId): string
    {
        return route('creator.reels.show', $reelId);
    }
}

if (!function_exists('calculateHMAC')) {
    /**
     * Calculate HMAC signature for a payload.
     *
     * @param array $payload
     * @param string $secret
     * @return string
     */
    function calculateHMAC(array $payload, string $secret): string
    {
        return hash_hmac('sha256', json_encode($payload), $secret);
    }
}