<?php

namespace App\Console\Commands;

use App\Jobs\UpdateCreatorAnalytics;
use Illuminate\Console\Command;

class ScheduleCreatorAnalytics extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'analytics:schedule-creator-update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Schedule nightly creator analytics updates';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Dispatch the UpdateCreatorAnalytics job
        UpdateCreatorAnalytics::dispatch();
        
        $this->info('Creator analytics update job scheduled successfully.');
    }
}