<?php

namespace App\Console\Commands;

use App\Jobs\UpdateBrandAnalytics;
use Illuminate\Console\Command;

class ScheduleBrandAnalytics extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'analytics:schedule-update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Schedule nightly brand analytics updates';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Dispatch the UpdateBrandAnalytics job
        UpdateBrandAnalytics::dispatch();
        
        $this->info('Brand analytics update job scheduled successfully.');
    }
}
