# Laravel-Python Integration Guide
## AI Business Market - Complete Integration Documentation

---

## 📋 Overview

Yeh document Laravel aur Python microservice ko connect karne ke liye complete guide hai. Isme saari required API keys, configuration steps, aur setup instructions hain.

---

## 🔑 Required API Keys & Configuration

### 1. **Python Microservice ke liye Required Keys**

#### A. AI Provider Keys (Python me use hongi)

| Service | Environment Variable | Kahan se milegi | Required/Optional |
|---------|---------------------|-----------------|-------------------|
| **OpenAI** | `OPENAI_API_KEY` | https://platform.openai.com/api-keys | **Required** |
| OpenAI Org ID | `OPENAI_ORG_ID` | https://platform.openai.com/account/org-settings | Optional |
| **Anthropic Claude** | `ANTHROPIC_API_KEY` | https://console.anthropic.com/settings/keys | Optional |

#### B. Social Media API Keys (Python me use hongi)

| Platform | Environment Variables | Kahan se milegi | Required/Optional |
|----------|----------------------|-----------------|-------------------|
| **Twitter/X** | `TWITTER_API_KEY`<br>`TWITTER_API_SECRET`<br>`TWITTER_ACCESS_TOKEN`<br>`TWITTER_ACCESS_SECRET`<br>`TWITTER_BEARER_TOKEN` | https://developer.twitter.com/en/portal/dashboard | Optional |
| **Facebook/Instagram** | `FACEBOOK_APP_ID`<br>`FACEBOOK_APP_SECRET`<br>`FACEBOOK_ACCESS_TOKEN` | https://developers.facebook.com/apps/ | Optional |
| **YouTube** | `YOUTUBE_CLIENT_ID`<br>`YOUTUBE_CLIENT_SECRET`<br>`YOUTUBE_REFRESH_TOKEN` | https://console.cloud.google.com/apis/credentials | Optional |
| **LinkedIn** | `LINKEDIN_CLIENT_ID`<br>`LINKEDIN_CLIENT_SECRET`<br>`LINKEDIN_ACCESS_TOKEN` | https://www.linkedin.com/developers/apps | Optional |

#### C. Infrastructure Keys (Python me use hongi)

| Service | Environment Variable | Default Value | Required/Optional |
|---------|---------------------|---------------|-------------------|
| **PostgreSQL** | `DATABASE_URL` | `postgresql+asyncpg://user:password@localhost:5432/ai_microservice` | **Required** |
| **Redis** | `REDIS_URL` | `redis://localhost:6379/0` | **Required** |
| **S3/MinIO** | `S3_ACCESS_KEY`<br>`S3_SECRET_KEY`<br>`S3_ENDPOINT_URL` | MinIO defaults | Optional |

#### D. Security Keys (Python me use hongi)

| Key | Environment Variable | Kaise generate karein | Required/Optional |
|-----|---------------------|----------------------|-------------------|
| **Secret Key** | `SECRET_KEY` | `openssl rand -hex 32` | **Required** |
| **Encryption Key** | `ENCRYPTION_KEY` | `openssl rand -hex 16` (32 bytes) | **Required** |
| **JWT Secret** | `JWT_SECRET` | `openssl rand -hex 32` | **Required** |

---

### 2. **Laravel ke liye Required Keys**

#### A. Python Microservice Connection (Laravel me use hongi)

| Key | Environment Variable | Description | Required/Optional |
|-----|---------------------|-------------|-------------------|
| **Python API URL** | `PYTHON_API_URL` | Python service ka base URL (e.g., `http://localhost:8000`) | **Required** |
| **Python API Key** | `PYTHON_API_KEY` | Laravel se Python ko authenticate karne ke liye | **Required** |
| **Callback Secret** | `PYTHON_CALLBACK_SECRET` | Python se Laravel ko callback verify karne ke liye | **Required** |

#### B. Social Media OAuth (Laravel me use hongi - Brand connections ke liye)

| Platform | Environment Variables | Kahan se milegi |
|----------|----------------------|-----------------|
| **YouTube** | `YOUTUBE_CLIENT_ID`<br>`YOUTUBE_CLIENT_SECRET`<br>`YOUTUBE_REDIRECT_URI` | https://console.cloud.google.com/apis/credentials |
| **Instagram** | `INSTAGRAM_CLIENT_ID`<br>`INSTAGRAM_CLIENT_SECRET`<br>`INSTAGRAM_REDIRECT_URI` | https://developers.facebook.com/apps/ |
| **Twitter** | `TWITTER_CLIENT_ID`<br>`TWITTER_CLIENT_SECRET`<br>`TWITTER_REDIRECT_URI` | https://developer.twitter.com/en/portal/dashboard |
| **LinkedIn** | `LINKEDIN_CLIENT_ID`<br>`LINKEDIN_CLIENT_SECRET`<br>`LINKEDIN_REDIRECT_URI` | https://www.linkedin.com/developers/apps |
| **TikTok** | `TIKTOK_CLIENT_KEY`<br>`TIKTOK_CLIENT_SECRET`<br>`TIKTOK_REDIRECT_URI` | https://developers.tiktok.com/ |

#### C. Payment Gateway (Laravel me use hongi)

| Service | Environment Variables | Kahan se milegi |
|---------|----------------------|-----------------|
| **Razorpay** | `RAZORPAY_KEY_ID`<br>`RAZORPAY_KEY_SECRET`<br>`RAZORPAY_WEBHOOK_SECRET` | https://dashboard.razorpay.com/app/keys |

---

## 🔧 Setup Instructions

### Step 1: Python Microservice Setup

1. **Navigate to Python directory:**
```bash
cd pytho
```

2. **Copy environment file:**
```bash
cp .env.example .env
```

3. **Update `.env` file with required keys:**

```bash
# Security Keys (REQUIRED)
SECRET_KEY=your-generated-secret-key-here
ENCRYPTION_KEY=your-32-byte-encryption-key-here
JWT_SECRET=your-jwt-secret-here

# AI Provider Keys (REQUIRED for AI features)
OPENAI_API_KEY=sk-your-openai-key-here
OPENAI_ORG_ID=org-your-org-id-here
ANTHROPIC_API_KEY=sk-ant-your-anthropic-key-here

# Database (REQUIRED)
DATABASE_URL=postgresql+asyncpg://user:password@localhost:5432/ai_microservice

# Redis (REQUIRED)
REDIS_URL=redis://localhost:6379/0

# Laravel Integration (REQUIRED)
LARAVEL_BASE_URL=http://localhost:8000
LARAVEL_API_KEY=your-shared-api-key-between-laravel-python
LARAVEL_CALLBACK_SECRET=your-shared-callback-secret

# Social Media Keys (OPTIONAL - only if using publishing features)
TWITTER_API_KEY=your-twitter-key
TWITTER_API_SECRET=your-twitter-secret
TWITTER_ACCESS_TOKEN=your-twitter-token
TWITTER_ACCESS_SECRET=your-twitter-token-secret
TWITTER_BEARER_TOKEN=your-twitter-bearer-token

FACEBOOK_APP_ID=your-facebook-app-id
FACEBOOK_APP_SECRET=your-facebook-app-secret
FACEBOOK_ACCESS_TOKEN=your-facebook-token

YOUTUBE_CLIENT_ID=your-youtube-client-id
YOUTUBE_CLIENT_SECRET=your-youtube-client-secret
YOUTUBE_REFRESH_TOKEN=your-youtube-refresh-token

LINKEDIN_CLIENT_ID=your-linkedin-client-id
LINKEDIN_CLIENT_SECRET=your-linkedin-client-secret
LINKEDIN_ACCESS_TOKEN=your-linkedin-token
```

4. **Install dependencies:**
```bash
pip install -r requirements.txt
```

5. **Start services using Docker:**
```bash
docker-compose up -d
```

OR **Start manually:**
```bash
# Terminal 1: Start API
uvicorn app.main:app --reload --host 0.0.0.0 --port 8000

# Terminal 2: Start Celery worker
celery -A app.celery_app worker --loglevel=info

# Terminal 3: Start Celery beat
celery -A app.celery_app beat --loglevel=info
```

---

### Step 2: Laravel Setup

1. **Navigate to Laravel directory:**
```bash
cd Laravel
```

2. **Update `.env` file:**

```bash
# Python Microservice Integration
PYTHON_API_URL=http://localhost:8000
PYTHON_API_KEY=your-shared-api-key-between-laravel-python
PYTHON_CALLBACK_SECRET=your-shared-callback-secret

# OpenAI (for Laravel-side AI features)
OPENAI_API_KEY=sk-your-openai-key-here
OPENAI_MODEL=gpt-4

# Social Media OAuth (for Brand connections)
YOUTUBE_CLIENT_ID=your-youtube-client-id
YOUTUBE_CLIENT_SECRET=your-youtube-client-secret
YOUTUBE_REDIRECT_URI=http://localhost:8000/brand/connections/callback/youtube

INSTAGRAM_CLIENT_ID=your-instagram-client-id
INSTAGRAM_CLIENT_SECRET=your-instagram-client-secret
INSTAGRAM_REDIRECT_URI=http://localhost:8000/brand/connections/callback/instagram

TWITTER_CLIENT_ID=your-twitter-client-id
TWITTER_CLIENT_SECRET=your-twitter-client-secret
TWITTER_REDIRECT_URI=http://localhost:8000/brand/connections/callback/twitter

LINKEDIN_CLIENT_ID=your-linkedin-client-id
LINKEDIN_CLIENT_SECRET=your-linkedin-client-secret
LINKEDIN_REDIRECT_URI=http://localhost:8000/brand/connections/callback/linkedin

TIKTOK_CLIENT_KEY=your-tiktok-client-key
TIKTOK_CLIENT_SECRET=your-tiktok-client-secret
TIKTOK_REDIRECT_URI=http://localhost:8000/brand/connections/callback/tiktok

# Razorpay Payment Gateway
RAZORPAY_KEY_ID=your-razorpay-key-id
RAZORPAY_KEY_SECRET=your-razorpay-key-secret
RAZORPAY_WEBHOOK_SECRET=your-razorpay-webhook-secret

# Reel Processing
REEL_PROCESSOR_URL=http://localhost:8001/process
REEL_PROCESSOR_SECRET=reel-secret-key
```

3. **Install dependencies:**
```bash
composer install
npm install
```

4. **Run migrations:**
```bash
php artisan migrate
```

5. **Start Laravel:**
```bash
php artisan serve
```

---

## 🔗 Integration Points

### 1. Laravel → Python API Calls

Laravel se Python microservice ko call karne ke liye:

**Endpoint:** `POST http://localhost:8000/v1/ai/jobs`

**Headers:**
```
X-API-Key: your-laravel-api-key
Content-Type: application/json
```

**Example Request:**
```json
{
  "job_type": "content_ideas",
  "tenant_id": "brand-123",
  "owner_id": "user-456",
  "payload": {
    "topic": "AI in marketing",
    "count": 5
  },
  "callback_url": "http://localhost:8000/api/ai-callback"
}
```

### 2. Python → Laravel Callbacks

Python se Laravel ko callback bhejne ke liye:

**Endpoint:** `POST http://localhost:8000/api/ai-callback`

**Headers:**
```
X-Callback-Signature: HMAC-SHA256 signature
Content-Type: application/json
```

---

## 📝 API Key Generation Commands

### Generate Security Keys:

```bash
# Secret Key (64 characters)
openssl rand -hex 32

# Encryption Key (32 bytes = 64 hex characters)
openssl rand -hex 16

# JWT Secret
openssl rand -hex 32

# Shared API Key between Laravel-Python
openssl rand -hex 24
```

---

## 🎯 Configuration File Locations

### Python Configuration:
- **Main config:** `pytho/.env`
- **Config class:** `pytho/config.py`

### Laravel Configuration:
- **Main config:** `Laravel/.env`
- **Services config:** `Laravel/config/services.php`
- **Python integration:** `Laravel/config/python.php` (to be created)

---

## ✅ Verification Steps

### 1. Check Python Service:
```bash
curl http://localhost:8000/health/readiness
```

### 2. Check Laravel-Python Connection:
```bash
# From Laravel
php artisan tinker
>>> Http::withHeaders(['X-API-Key' => env('PYTHON_API_KEY')])->get(env('PYTHON_API_URL') . '/health/readiness');
```

### 3. Test AI Job:
```bash
curl -X POST http://localhost:8000/v1/ai/jobs \
  -H "X-API-Key: your-api-key" \
  -H "Content-Type: application/json" \
  -d '{
    "job_type": "content_ideas",
    "tenant_id": "test-123",
    "owner_id": "user-456",
    "payload": {"topic": "test"}
  }'
```

---

## 🚨 Important Notes

1. **Same API Keys:** Kuch keys dono systems me same honi chahiye:
   - `PYTHON_API_KEY` / `LARAVEL_API_KEY` - Authentication ke liye
   - `PYTHON_CALLBACK_SECRET` / `LARAVEL_CALLBACK_SECRET` - Callback verification ke liye

2. **Different API Keys:** Kuch keys alag-alag systems me use hongi:
   - Social Media OAuth keys - Laravel me (user-facing connections)
   - Social Media API keys - Python me (automated publishing)
   - OpenAI key - Dono me use ho sakti hai

3. **Security:** Production me:
   - Strong keys generate karein
   - `.env` files ko `.gitignore` me rakhein
   - HTTPS use karein
   - Rate limiting enable karein

---

## 📞 Support

Issues ke liye:
1. Logs check karein: `Laravel/storage/logs/laravel.log`
2. Python logs: `docker-compose logs api`
3. Database connection verify karein
4. API keys validate karein
