# AI Business Market - Complete Deployment Requirements
## Server, Software & Infrastructure Setup Guide

---

## 📋 Table of Contents

1. [System Requirements](#system-requirements)
2. [Software Requirements](#software-requirements)
3. [Server Requirements](#server-requirements)
4. [Development Environment Setup](#development-environment-setup)
5. [Production Environment Setup](#production-environment-setup)
6. [Third-Party Services](#third-party-services)
7. [Cost Estimation](#cost-estimation)
8. [Step-by-Step Installation](#step-by-step-installation)

---

## 1. System Requirements

### Minimum Requirements (Development):

| Component | Requirement |
|-----------|-------------|
| **CPU** | 2 cores (4 recommended) |
| **RAM** | 4 GB (8 GB recommended) |
| **Storage** | 20 GB free space |
| **OS** | Windows 10/11, Ubuntu 20.04+, macOS 10.15+ |
| **Internet** | Stable connection for API calls |

### Recommended Requirements (Production):

| Component | Requirement |
|-----------|-------------|
| **CPU** | 4+ cores |
| **RAM** | 16 GB+ |
| **Storage** | 100 GB+ SSD |
| **OS** | Ubuntu 22.04 LTS (Server) |
| **Internet** | High-speed, dedicated connection |

---

## 2. Software Requirements

### A. Laravel Requirements:

#### Core Software:
```
✅ PHP 8.1 or higher
✅ Composer (PHP package manager)
✅ Node.js 18+ & NPM (for frontend assets)
✅ Web Server (Apache/Nginx)
```

#### PHP Extensions Required:
```
✅ php-cli
✅ php-fpm
✅ php-mysql (or php-sqlite)
✅ php-pgsql (optional)
✅ php-mbstring
✅ php-xml
✅ php-curl
✅ php-zip
✅ php-gd
✅ php-bcmath
✅ php-json
✅ php-redis (optional but recommended)
```

#### Database:
```
Choose one:
✅ SQLite (for development)
✅ MySQL 8.0+ (recommended for production)
✅ PostgreSQL 13+ (alternative)
```

### B. Python Requirements:

#### Core Software:
```
✅ Python 3.11 or higher
✅ pip (Python package manager)
✅ virtualenv or venv
```

#### Python Packages (from requirements.txt):
```
✅ fastapi
✅ uvicorn
✅ celery
✅ redis
✅ sqlalchemy
✅ asyncpg
✅ openai
✅ anthropic
✅ tweepy (Twitter)
✅ facebook-sdk
✅ google-api-python-client (YouTube)
✅ linkedin-api
✅ sentence-transformers
✅ faiss-cpu (or faiss-gpu)
✅ pydantic
✅ python-multipart
✅ httpx
✅ cryptography
```

### C. Infrastructure Services:

#### Required Services:
```
✅ PostgreSQL 15+ (for Python microservice)
✅ Redis 7+ (for Celery task queue & caching)
✅ Docker & Docker Compose (recommended)
```

#### Optional Services:
```
⭕ Weaviate (for advanced RAG)
⭕ MinIO/S3 (for file storage)
⭕ Prometheus (for monitoring)
⭕ Grafana (for dashboards)
```

---

## 3. Server Requirements

### Development Setup (Local Machine):

**Option 1: XAMPP (Windows)**
```
✅ XAMPP 8.2+ (includes PHP, Apache, MySQL)
✅ Download: https://www.apachefriends.org/
```

**Option 2: Laravel Valet (macOS)**
```
✅ Laravel Valet
✅ Homebrew
✅ PHP 8.1+
```

**Option 3: Docker (All Platforms)**
```
✅ Docker Desktop
✅ Docker Compose
```

### Production Setup:

#### Option 1: VPS (Virtual Private Server)

**Recommended Providers:**
- **DigitalOcean** - Droplet ($12-$48/month)
- **Linode** - Shared CPU ($12-$48/month)
- **Vultr** - Cloud Compute ($12-$48/month)
- **AWS EC2** - t3.medium or larger
- **Google Cloud** - e2-medium or larger
- **Azure** - B2s or larger

**Minimum VPS Specs:**
```
✅ 2 vCPUs
✅ 4 GB RAM
✅ 80 GB SSD
✅ Ubuntu 22.04 LTS
✅ 4 TB bandwidth
```

**Recommended VPS Specs:**
```
✅ 4 vCPUs
✅ 8 GB RAM
✅ 160 GB SSD
✅ Ubuntu 22.04 LTS
✅ Unlimited bandwidth
```

#### Option 2: Managed Hosting

**Laravel Hosting:**
- **Laravel Forge** + DigitalOcean ($12/month + $12/month)
- **Cloudways** ($26-$96/month)
- **Ploi.io** + VPS ($10/month + $12/month)

**Python Hosting:**
- **Railway.app** ($5-$20/month)
- **Render.com** ($7-$25/month)
- **Heroku** ($7-$25/month)
- **PythonAnywhere** ($5-$99/month)

#### Option 3: Serverless

**For Python Microservice:**
- **AWS Lambda** + API Gateway
- **Google Cloud Functions**
- **Azure Functions**

---

## 4. Development Environment Setup

### Step 1: Install Core Software

#### Windows (XAMPP):

```bash
# 1. Download & Install XAMPP
https://www.apachefriends.org/download.html

# 2. Install Composer
https://getcomposer.org/download/

# 3. Install Node.js
https://nodejs.org/en/download/

# 4. Install Python
https://www.python.org/downloads/

# 5. Install Docker Desktop
https://www.docker.com/products/docker-desktop/
```

#### Ubuntu/Linux:

```bash
# Update system
sudo apt update && sudo apt upgrade -y

# Install PHP 8.2
sudo apt install -y php8.2 php8.2-cli php8.2-fpm php8.2-mysql \
  php8.2-xml php8.2-curl php8.2-zip php8.2-gd php8.2-mbstring \
  php8.2-bcmath php8.2-redis

# Install Composer
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer

# Install Node.js 18
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt install -y nodejs

# Install Python 3.11
sudo apt install -y python3.11 python3.11-venv python3-pip

# Install Docker
curl -fsSL https://get.docker.com -o get-docker.sh
sudo sh get-docker.sh
sudo usermod -aG docker $USER

# Install Docker Compose
sudo apt install -y docker-compose-plugin
```

#### macOS:

```bash
# Install Homebrew
/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"

# Install PHP
brew install php@8.2

# Install Composer
brew install composer

# Install Node.js
brew install node@18

# Install Python
brew install python@3.11

# Install Docker Desktop
brew install --cask docker
```

### Step 2: Setup Laravel

```bash
# Navigate to Laravel directory
cd "c:/xampp/htdocs/AI business market/Laravel"

# Install dependencies
composer install
npm install

# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate

# Run migrations
php artisan migrate

# Seed demo data (optional)
php artisan db:seed

# Build frontend assets
npm run build

# Start development server
php artisan serve
# Access: http://localhost:8000
```

### Step 3: Setup Python Microservice

```bash
# Navigate to Python directory
cd "c:/xampp/htdocs/AI business market/pytho"

# Create virtual environment
python -m venv venv

# Activate virtual environment
# Windows:
venv\Scripts\activate
# Linux/Mac:
source venv/bin/activate

# Install dependencies
pip install -r requirements.txt

# Copy environment file
cp .env.example .env

# Start services with Docker
docker-compose up -d

# OR start manually:
# Terminal 1: Start API
uvicorn app.main:app --reload --host 0.0.0.0 --port 8000

# Terminal 2: Start Celery worker
celery -A app.celery_app worker --loglevel=info

# Terminal 3: Start Celery beat
celery -A app.celery_app beat --loglevel=info
```

---

## 5. Production Environment Setup

### Step 1: Server Setup (Ubuntu 22.04)

```bash
# Connect to server
ssh root@your-server-ip

# Update system
apt update && apt upgrade -y

# Install essential tools
apt install -y curl wget git unzip software-properties-common

# Install Nginx
apt install -y nginx

# Install Certbot (for SSL)
apt install -y certbot python3-certbot-nginx

# Install Supervisor (for process management)
apt install -y supervisor

# Install fail2ban (security)
apt install -y fail2ban
```

### Step 2: Install Software Stack

```bash
# Install PHP 8.2
add-apt-repository ppa:ondrej/php -y
apt update
apt install -y php8.2-fpm php8.2-cli php8.2-mysql php8.2-xml \
  php8.2-curl php8.2-zip php8.2-gd php8.2-mbstring php8.2-bcmath \
  php8.2-redis php8.2-pgsql

# Install Composer
curl -sS https://getcomposer.org/installer | php
mv composer.phar /usr/local/bin/composer

# Install Node.js 18
curl -fsSL https://deb.nodesource.com/setup_18.x | bash -
apt install -y nodejs

# Install Python 3.11
apt install -y python3.11 python3.11-venv python3-pip

# Install PostgreSQL 15
apt install -y postgresql-15 postgresql-contrib-15

# Install Redis
apt install -y redis-server

# Install Docker
curl -fsSL https://get.docker.com | sh
usermod -aG docker $USER
```

### Step 3: Configure Nginx

```nginx
# /etc/nginx/sites-available/laravel.conf

server {
    listen 80;
    server_name yourdomain.com www.yourdomain.com;
    root /var/www/laravel/public;

    add_header X-Frame-Options "SAMEORIGIN";
    add_header X-Content-Type-Options "nosniff";

    index index.php;

    charset utf-8;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location = /favicon.ico { access_log off; log_not_found off; }
    location = /robots.txt  { access_log off; log_not_found off; }

    error_page 404 /index.php;

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.2-fpm.sock;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }

    location ~ /\.(?!well-known).* {
        deny all;
    }
}

# Python API reverse proxy
server {
    listen 80;
    server_name api.yourdomain.com;

    location / {
        proxy_pass http://localhost:8000;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
    }
}
```

### Step 4: Configure Supervisor (Python Services)

```ini
# /etc/supervisor/conf.d/python-api.conf

[program:python-api]
command=/var/www/python/venv/bin/uvicorn app.main:app --host 0.0.0.0 --port 8000
directory=/var/www/python
user=www-data
autostart=true
autorestart=true
redirect_stderr=true
stdout_logfile=/var/log/python-api.log

[program:celery-worker]
command=/var/www/python/venv/bin/celery -A app.celery_app worker --loglevel=info
directory=/var/www/python
user=www-data
autostart=true
autorestart=true
redirect_stderr=true
stdout_logfile=/var/log/celery-worker.log

[program:celery-beat]
command=/var/www/python/venv/bin/celery -A app.celery_app beat --loglevel=info
directory=/var/www/python
user=www-data
autostart=true
autorestart=true
redirect_stderr=true
stdout_logfile=/var/log/celery-beat.log
```

### Step 5: SSL Certificate

```bash
# Get SSL certificate
certbot --nginx -d yourdomain.com -d www.yourdomain.com -d api.yourdomain.com

# Auto-renewal
certbot renew --dry-run
```

---

## 6. Third-Party Services

### Required Services:

#### 1. OpenAI API
- **Website:** https://platform.openai.com/
- **Cost:** Pay-as-you-go
  - GPT-4: $0.03 per 1K tokens (input), $0.06 per 1K tokens (output)
  - GPT-3.5: $0.0015 per 1K tokens
- **Setup:**
  1. Create account
  2. Add payment method
  3. Generate API key
  4. Add to `.env`: `OPENAI_API_KEY=sk-...`

#### 2. Razorpay (Payment Gateway)
- **Website:** https://razorpay.com/
- **Cost:** 2% per transaction
- **Setup:**
  1. Create account
  2. Complete KYC
  3. Get API keys (Test & Live)
  4. Add to `.env`: `RAZORPAY_KEY_ID=...`

### Optional Services:

#### 3. Anthropic Claude (Alternative AI)
- **Website:** https://console.anthropic.com/
- **Cost:** Pay-as-you-go
  - Claude 3: $0.015 per 1K tokens
- **Setup:** Similar to OpenAI

#### 4. Social Media APIs

**Twitter/X:**
- **Website:** https://developer.twitter.com/
- **Cost:** Free tier available, Paid plans from $100/month
- **Setup:** Create app, get API keys

**Facebook/Instagram:**
- **Website:** https://developers.facebook.com/
- **Cost:** Free
- **Setup:** Create app, get App ID & Secret

**YouTube:**
- **Website:** https://console.cloud.google.com/
- **Cost:** Free (10,000 quota units/day)
- **Setup:** Enable YouTube Data API v3

**LinkedIn:**
- **Website:** https://www.linkedin.com/developers/
- **Cost:** Free
- **Setup:** Create app, get Client ID & Secret

#### 5. Email Service (Optional)
- **Mailgun:** $35/month for 50K emails
- **SendGrid:** $19.95/month for 50K emails
- **Amazon SES:** $0.10 per 1,000 emails

#### 6. Monitoring (Optional)
- **Sentry:** Error tracking ($26/month)
- **New Relic:** Performance monitoring ($99/month)
- **Datadog:** Infrastructure monitoring ($15/host/month)

---

## 7. Cost Estimation

### Development (Local):
```
💰 Total: $0-$20/month

✅ XAMPP/Local Server: Free
✅ Docker Desktop: Free
✅ OpenAI API (testing): ~$5-$10/month
✅ Domain (optional): ~$10/year
```

### Production (Small Scale):

#### Option 1: Single VPS
```
💰 Total: ~$50-$100/month

✅ VPS (4GB RAM): $12-$24/month
✅ Domain: $10/year (~$1/month)
✅ SSL Certificate: Free (Let's Encrypt)
✅ OpenAI API: $20-$50/month
✅ Razorpay: 2% per transaction
✅ Email Service: $0-$20/month
```

#### Option 2: Managed Hosting
```
💰 Total: ~$80-$150/month

✅ Laravel Forge: $12/month
✅ DigitalOcean Droplet: $24/month
✅ Python Hosting (Render): $25/month
✅ Domain: $1/month
✅ OpenAI API: $20-$50/month
✅ Razorpay: 2% per transaction
✅ Email Service: $20/month
```

### Production (Medium Scale):

```
💰 Total: ~$200-$500/month

✅ VPS (8GB RAM): $48/month
✅ Database (Managed): $15-$50/month
✅ Redis (Managed): $10-$30/month
✅ CDN (Cloudflare): $20/month
✅ Backup Storage: $10/month
✅ OpenAI API: $100-$200/month
✅ Monitoring: $50/month
✅ Email Service: $35/month
```

---

## 8. Step-by-Step Installation

### Complete Setup (Development):

```bash
# ============================================
# STEP 1: Install XAMPP (Windows)
# ============================================
1. Download XAMPP from https://www.apachefriends.org/
2. Install to C:\xampp
3. Start Apache and MySQL from XAMPP Control Panel

# ============================================
# STEP 2: Install Additional Software
# ============================================
1. Install Composer: https://getcomposer.org/download/
2. Install Node.js: https://nodejs.org/
3. Install Python: https://www.python.org/downloads/
4. Install Docker Desktop: https://www.docker.com/products/docker-desktop/

# ============================================
# STEP 3: Setup Laravel
# ============================================
cd "c:\xampp\htdocs\AI business market\Laravel"

# Install dependencies
composer install
npm install

# Setup environment
copy .env.example .env
php artisan key:generate

# Configure database in .env
DB_CONNECTION=sqlite

# Run migrations
php artisan migrate

# Build assets
npm run build

# Start server
php artisan serve
# Visit: http://localhost:8000

# ============================================
# STEP 4: Setup Python
# ============================================
cd "c:\xampp\htdocs\AI business market\pytho"

# Create virtual environment
python -m venv venv
venv\Scripts\activate

# Install dependencies
pip install -r requirements.txt

# Setup environment
copy .env.example .env

# Start with Docker
docker-compose up -d

# OR start manually:
# Terminal 1:
uvicorn app.main:app --reload

# Terminal 2:
celery -A app.celery_app worker --loglevel=info

# ============================================
# STEP 5: Configure API Keys
# ============================================
# Edit Laravel/.env
PYTHON_API_URL=http://localhost:8000
PYTHON_API_KEY=9b902b45f6271c2db9b8863bf5ace6b58a68124096556022cb35243ccea73544
PYTHON_CALLBACK_SECRET=7f3d8e9c2a1b4f6e8d7c5a3b9e1f4d2c8a6b5e3f7d9c1a4b8e6f2d5c3a7b9e1f
OPENAI_API_KEY=your-openai-key

# Edit pytho/.env
LARAVEL_API_KEY=9b902b45f6271c2db9b8863bf5ace6b58a68124096556022cb35243ccea73544
LARAVEL_CALLBACK_SECRET=7f3d8e9c2a1b4f6e8d7c5a3b9e1f4d2c8a6b5e3f7d9c1a4b8e6f2d5c3a7b9e1f
LARAVEL_BASE_URL=http://localhost:8000
OPENAI_API_KEY=your-openai-key

# ============================================
# STEP 6: Test Integration
# ============================================
php test_integration.php

# ============================================
# STEP 7: Access Application
# ============================================
Laravel: http://localhost:8000
Python API: http://localhost:8000 (if using Docker)
Python API Docs: http://localhost:8000/docs
```

---

## 📋 Quick Checklist

### Before Starting:
- [ ] XAMPP installed (or equivalent)
- [ ] Composer installed
- [ ] Node.js installed
- [ ] Python 3.11+ installed
- [ ] Docker Desktop installed
- [ ] OpenAI API key obtained
- [ ] Razorpay account created (for payments)

### Laravel Setup:
- [ ] Dependencies installed (`composer install`)
- [ ] `.env` file configured
- [ ] Database migrated
- [ ] Frontend assets built (`npm run build`)
- [ ] Server running (`php artisan serve`)

### Python Setup:
- [ ] Virtual environment created
- [ ] Dependencies installed (`pip install -r requirements.txt`)
- [ ] `.env` file configured
- [ ] PostgreSQL running
- [ ] Redis running
- [ ] Services started (API + Celery)

### Integration:
- [ ] API keys match in both systems
- [ ] Health check passing
- [ ] Test integration successful

---

## 🎯 Summary

### Minimum Requirements to Run:
1. **XAMPP** (PHP + Apache + MySQL)
2. **Composer** (PHP packages)
3. **Node.js** (Frontend assets)
4. **Python 3.11+** (AI microservice)
5. **Docker Desktop** (PostgreSQL + Redis)
6. **OpenAI API Key** (AI features)

### Total Setup Time:
- **Development:** 1-2 hours
- **Production:** 4-8 hours

### Total Cost:
- **Development:** $0-$20/month
- **Production:** $50-$500/month (depending on scale)

**Sab kuch ready hai! Follow the steps and your product will be running! 🚀**