# VPS Deployment Guide - AI Business Market
## Automated One-Click Deployment

---

## 🚀 Quick Start

Yeh guide aapko step-by-step batayegi ki kaise aap apna project VPS par deploy kar sakte ho using automated script.

---

## 📋 Prerequisites

### 1. VPS Server Requirements:
- **OS:** Ubuntu 22.04 LTS (Fresh installation)
- **RAM:** Minimum 4GB (8GB recommended)
- **Storage:** Minimum 40GB
- **Access:** Root SSH access

### 2. VPS Providers (Choose any):
- **DigitalOcean** - https://www.digitalocean.com/ ($12-$24/month)
- **Linode** - https://www.linode.com/ ($12-$24/month)
- **Vultr** - https://www.vultr.com/ ($12-$24/month)
- **Hetzner** - https://www.hetzner.com/ (€4-€8/month)

### 3. Domain Name:
- Buy from: Namecheap, GoDaddy, or Cloudflare
- Point A records to your VPS IP:
  - `@` → Your VPS IP
  - `www` → Your VPS IP
  - `api` → Your VPS IP

---

## 🎯 Deployment Steps

### Step 1: Create VPS

1. **Login to your VPS provider**
2. **Create new droplet/instance:**
   - Choose: Ubuntu 22.04 LTS
   - Plan: 4GB RAM / 2 CPUs
   - Region: Choose nearest to your users
   - Authentication: SSH Key (recommended) or Password

3. **Note down:**
   - VPS IP Address: `123.456.789.0`
   - Root password (if using password auth)

### Step 2: Upload Deployment Script

**From your local machine (Windows):**

```bash
# Open PowerShell or Command Prompt
cd "c:\xampp\htdocs\AI business market"

# Upload deploy.sh to VPS
scp deploy.sh root@YOUR_VPS_IP:/root/

# Example:
# scp deploy.sh root@123.456.789.0:/root/
```

**Enter password when prompted**

### Step 3: Run Deployment Script

**SSH into your VPS:**

```bash
# Connect to VPS
ssh root@YOUR_VPS_IP

# Example:
# ssh root@123.456.789.0
```

**Run the deployment script:**

```bash
# Make script executable
chmod +x /root/deploy.sh

# Run deployment
./deploy.sh
```

**Script will ask for your domain name:**
```
Enter your domain name (e.g., example.com):
yourdomain.com
```

**Wait 10-15 minutes for installation to complete.**

### Step 4: Upload Your Project

**The script will create upload instructions. Read them:**

```bash
cat /root/UPLOAD_INSTRUCTIONS.txt
```

**From your local machine, upload Laravel:**

```bash
# Navigate to project
cd "c:\xampp\htdocs\AI business market"

# Create production .env for Laravel
copy Laravel\.env.example Laravel\.env.production

# Edit Laravel/.env.production with production settings
# (Use Notepad or any text editor)

# Upload Laravel (using rsync or WinSCP)
# If you have rsync:
rsync -avz --exclude node_modules --exclude vendor --exclude .git Laravel/ root@YOUR_VPS_IP:/var/www/laravel/

# OR use WinSCP (Windows GUI tool):
# 1. Download WinSCP: https://winscp.net/
# 2. Connect to your VPS
# 3. Upload Laravel folder to /var/www/laravel/
```

**Upload Python:**

```bash
# Create production .env for Python
copy pytho\.env.example pytho\.env.production

# Edit pytho/.env.production with production settings

# Upload Python
rsync -avz --exclude venv --exclude __pycache__ --exclude .git pytho/ root@YOUR_VPS_IP:/var/www/python/

# OR use WinSCP to upload pytho folder to /var/www/python/
```

### Step 5: Deploy Project

**On the VPS, run deployment:**

```bash
ssh root@YOUR_VPS_IP
cd /root
./deploy_project.sh
```

This will:
- Install Laravel dependencies
- Install Python dependencies
- Run migrations
- Setup permissions
- Restart all services

### Step 6: Setup SSL Certificate

```bash
# On VPS, run:
certbot --nginx -d yourdomain.com -d www.yourdomain.com -d api.yourdomain.com

# Follow prompts:
# - Enter email
# - Agree to terms
# - Choose redirect HTTP to HTTPS (option 2)
```

### Step 7: Configure API Keys

**Edit Laravel .env:**

```bash
nano /var/www/laravel/.env
```

Add your API keys:
```env
OPENAI_API_KEY=sk-your-openai-key
RAZORPAY_KEY_ID=rzp_live_xxxxx
RAZORPAY_KEY_SECRET=xxxxx
```

**Edit Python .env:**

```bash
nano /var/www/python/.env
```

Add your API keys:
```env
OPENAI_API_KEY=sk-your-openai-key
```

**Restart services:**

```bash
supervisorctl restart all
systemctl restart php8.2-fpm
systemctl restart nginx
```

### Step 8: Test Your Application

**Visit your website:**
- Main site: `https://yourdomain.com`
- API docs: `https://api.yourdomain.com/docs`

**Test integration:**

```bash
# On VPS
cd /var/www/laravel
php artisan tinker

# In tinker:
>>> app(\App\Services\PythonApiService::class)->checkHealth()
# Should return: true
```

---

## 📁 What the Script Installs

### Software Installed:
```
✅ Nginx (Web server)
✅ PHP 8.2 + Extensions
✅ Composer
✅ Node.js 18
✅ Python 3.11
✅ PostgreSQL 15
✅ Redis 7
✅ Supervisor (Process manager)
✅ Certbot (SSL certificates)
✅ UFW Firewall
```

### Directories Created:
```
/var/www/laravel/     - Laravel application
/var/www/python/      - Python microservice
/root/credentials.txt - Database & API credentials
/root/UPLOAD_INSTRUCTIONS.txt - Upload guide
/root/deploy_project.sh - Deployment script
```

### Services Configured:
```
✅ Nginx - Port 80/443
✅ PHP-FPM - Unix socket
✅ PostgreSQL - Port 5432
✅ Redis - Port 6379
✅ Python API - Port 8000 (internal)
✅ Celery Worker - Background tasks
✅ Celery Beat - Scheduled tasks
```

---

## 🔧 Post-Deployment Configuration

### 1. View Credentials

```bash
cat /root/credentials.txt
```

This file contains:
- Database credentials
- Generated API keys
- Integration secrets

### 2. Monitor Services

```bash
# Check all services
supervisorctl status

# View logs
tail -f /var/log/python-api.log
tail -f /var/log/celery-worker.log
tail -f /var/www/laravel/storage/logs/laravel.log
```

### 3. Restart Services

```bash
# Restart Python services
supervisorctl restart all

# Restart PHP
systemctl restart php8.2-fpm

# Restart Nginx
systemctl restart nginx
```

### 4. Update Application

```bash
# Upload new code from local machine
rsync -avz Laravel/ root@YOUR_VPS_IP:/var/www/laravel/

# On VPS, run deployment
ssh root@YOUR_VPS_IP
cd /root
./deploy_project.sh
```

---

## 🐛 Troubleshooting

### Issue 1: Cannot connect to website

**Check Nginx:**
```bash
systemctl status nginx
nginx -t
```

**Check firewall:**
```bash
ufw status
ufw allow 80/tcp
ufw allow 443/tcp
```

### Issue 2: 502 Bad Gateway

**Check PHP-FPM:**
```bash
systemctl status php8.2-fpm
systemctl restart php8.2-fpm
```

**Check Python API:**
```bash
supervisorctl status python-api
supervisorctl restart python-api
tail -f /var/log/python-api.log
```

### Issue 3: Database connection error

**Check PostgreSQL:**
```bash
systemctl status postgresql
sudo -u postgres psql -l
```

**Test connection:**
```bash
psql -U aiuser -d ai_business_db -h localhost
```

### Issue 4: Python API not responding

**Check logs:**
```bash
tail -f /var/log/python-api.log
tail -f /var/log/celery-worker.log
```

**Restart services:**
```bash
supervisorctl restart all
```

### Issue 5: SSL certificate issues

**Renew certificate:**
```bash
certbot renew
systemctl restart nginx
```

---

## 📊 Performance Optimization

### 1. Enable OPcache (PHP)

```bash
nano /etc/php/8.2/fpm/php.ini
```

Add:
```ini
opcache.enable=1
opcache.memory_consumption=256
opcache.max_accelerated_files=20000
opcache.validate_timestamps=0
```

Restart PHP:
```bash
systemctl restart php8.2-fpm
```

### 2. Configure Redis Cache

**Laravel .env:**
```env
CACHE_DRIVER=redis
SESSION_DRIVER=redis
QUEUE_CONNECTION=redis
```

### 3. Enable Gzip Compression

```bash
nano /etc/nginx/nginx.conf
```

Add in http block:
```nginx
gzip on;
gzip_vary on;
gzip_min_length 1024;
gzip_types text/plain text/css text/xml text/javascript application/x-javascript application/xml+rss application/json;
```

Restart Nginx:
```bash
systemctl restart nginx
```

---

## 🔒 Security Hardening

### 1. Change SSH Port

```bash
nano /etc/ssh/sshd_config
```

Change:
```
Port 2222
```

Update firewall:
```bash
ufw allow 2222/tcp
ufw delete allow 22/tcp
systemctl restart sshd
```

### 2. Disable Root Login

```bash
nano /etc/ssh/sshd_config
```

Change:
```
PermitRootLogin no
```

### 3. Setup Fail2Ban

```bash
apt install -y fail2ban
systemctl enable fail2ban
systemctl start fail2ban
```

### 4. Regular Updates

```bash
# Create update script
cat > /root/update.sh << 'EOF'
#!/bin/bash
apt update
apt upgrade -y
apt autoremove -y
EOF

chmod +x /root/update.sh

# Run weekly
crontab -e
# Add: 0 2 * * 0 /root/update.sh
```

---

## 💾 Backup Strategy

### 1. Database Backup

```bash
# Create backup script
cat > /root/backup_db.sh << 'EOF'
#!/bin/bash
BACKUP_DIR="/root/backups"
DATE=$(date +%Y%m%d_%H%M%S)
mkdir -p $BACKUP_DIR

# Backup PostgreSQL
pg_dump -U aiuser ai_business_db > $BACKUP_DIR/db_$DATE.sql

# Keep only last 7 days
find $BACKUP_DIR -name "db_*.sql" -mtime +7 -delete
EOF

chmod +x /root/backup_db.sh

# Run daily
crontab -e
# Add: 0 3 * * * /root/backup_db.sh
```

### 2. Files Backup

```bash
# Backup Laravel storage
tar -czf /root/backups/laravel_storage_$(date +%Y%m%d).tar.gz /var/www/laravel/storage

# Backup Python data
tar -czf /root/backups/python_data_$(date +%Y%m%d).tar.gz /var/www/python/data
```

---

## 📈 Monitoring

### 1. Setup Monitoring Script

```bash
cat > /root/monitor.sh << 'EOF'
#!/bin/bash
echo "=== System Status ==="
echo "CPU: $(top -bn1 | grep "Cpu(s)" | awk '{print $2}')%"
echo "RAM: $(free -m | awk 'NR==2{printf "%.2f%%", $3*100/$2 }')"
echo "Disk: $(df -h / | awk 'NR==2{print $5}')"
echo ""
echo "=== Services Status ==="
systemctl status nginx --no-pager | grep Active
systemctl status php8.2-fpm --no-pager | grep Active
systemctl status postgresql --no-pager | grep Active
systemctl status redis --no-pager | grep Active
supervisorctl status
EOF

chmod +x /root/monitor.sh
```

Run: `./monitor.sh`

---

## ✅ Deployment Checklist

### Pre-Deployment:
- [ ] VPS created with Ubuntu 22.04
- [ ] Domain name purchased and DNS configured
- [ ] SSH access to VPS working
- [ ] deploy.sh script uploaded

### During Deployment:
- [ ] deploy.sh executed successfully
- [ ] All services installed
- [ ] Credentials saved
- [ ] Project files uploaded
- [ ] deploy_project.sh executed
- [ ] SSL certificate installed

### Post-Deployment:
- [ ] Website accessible via HTTPS
- [ ] API docs accessible
- [ ] Laravel-Python integration working
- [ ] Database connected
- [ ] Redis working
- [ ] Celery workers running
- [ ] Logs being generated
- [ ] Backups configured
- [ ] Monitoring setup

---

## 🎉 Success!

Agar sab steps follow kiye to aapka project successfully deploy ho gaya hai!

**Access your application:**
- Website: `https://yourdomain.com`
- API: `https://api.yourdomain.com`
- API Docs: `https://api.yourdomain.com/docs`

**Important commands:**
```bash
# View credentials
cat /root/credentials.txt

# Monitor services
supervisorctl status

# View logs
tail -f /var/log/python-api.log

# Restart services
supervisorctl restart all
```

**Need help?** Check troubleshooting section above!