# API Keys Configuration Checklist
## AI Business Market - Laravel + Python Integration

---

## 🎯 Quick Summary

Yeh checklist aapko batayegi ki **kaunsi API keys kahan update karni hain** aur **kahan se obtain karni hain**.

---

## 📍 Configuration Files Location

### Laravel Files:
- **Main Environment:** `Laravel/.env`
- **Example Template:** `Laravel/.env.example`
- **Services Config:** `Laravel/config/services.php`
- **Python Config:** `Laravel/config/python.php`

### Python Files:
- **Main Environment:** `pytho/.env`
- **Example Template:** `pytho/.env.example`
- **Config Class:** `pytho/config.py`

---

## ✅ Step-by-Step API Keys Setup

### 🔐 STEP 1: Security Keys (REQUIRED - Dono systems me)

#### Generate Commands:
```bash
# Secret Key (64 characters)
openssl rand -hex 32

# Encryption Key (32 bytes)
openssl rand -hex 16

# JWT Secret
openssl rand -hex 32

# Shared API Key
openssl rand -hex 24

# Callback Secret
openssl rand -hex 32
```

#### Update Locations:

**Python (`pytho/.env`):**
```bash
SECRET_KEY=<generated-secret-key>
ENCRYPTION_KEY=<generated-encryption-key>
JWT_SECRET=<generated-jwt-secret>
LARAVEL_API_KEY=<shared-api-key>
LARAVEL_CALLBACK_SECRET=<shared-callback-secret>
```

**Laravel (`Laravel/.env`):**
```bash
PYTHON_API_KEY=<same-shared-api-key-as-above>
PYTHON_CALLBACK_SECRET=<same-shared-callback-secret-as-above>
```

---

### 🤖 STEP 2: AI Provider Keys (Python me REQUIRED)

#### OpenAI API Key

**Kahan se milegi:**
1. Visit: https://platform.openai.com/api-keys
2. Login/Signup karein
3. "Create new secret key" click karein
4. Key copy karein (sirf ek baar dikhegi)

**Update Location:**
```bash
# pytho/.env
OPENAI_API_KEY=sk-proj-xxxxxxxxxxxxx
OPENAI_ORG_ID=org-xxxxxxxxxxxxx  # Optional
```

**Cost:** Pay-as-you-go (GPT-4: ~$0.03 per 1K tokens)

---

#### Anthropic Claude API Key (Optional)

**Kahan se milegi:**
1. Visit: https://console.anthropic.com/settings/keys
2. Account create karein
3. "Create Key" click karein
4. Key copy karein

**Update Location:**
```bash
# pytho/.env
ANTHROPIC_API_KEY=sk-ant-xxxxxxxxxxxxx
```

**Cost:** Pay-as-you-go (Claude 3: ~$0.015 per 1K tokens)

---

### 📱 STEP 3: Social Media Keys (Optional - Feature-based)

#### A. Twitter/X API Keys (Python me - for automated publishing)

**Kahan se milegi:**
1. Visit: https://developer.twitter.com/en/portal/dashboard
2. Create App
3. Generate API Keys & Tokens
4. Enable OAuth 2.0

**Update Location:**
```bash
# pytho/.env
TWITTER_API_KEY=xxxxxxxxxxxxx
TWITTER_API_SECRET=xxxxxxxxxxxxx
TWITTER_ACCESS_TOKEN=xxxxxxxxxxxxx
TWITTER_ACCESS_SECRET=xxxxxxxxxxxxx
TWITTER_BEARER_TOKEN=xxxxxxxxxxxxx
```

**Laravel me (for OAuth connections):**
```bash
# Laravel/.env
TWITTER_CLIENT_ID=xxxxxxxxxxxxx
TWITTER_CLIENT_SECRET=xxxxxxxxxxxxx
TWITTER_REDIRECT_URI=http://localhost:8000/brand/connections/callback/twitter
```

---

#### B. Facebook/Instagram API Keys

**Kahan se milegi:**
1. Visit: https://developers.facebook.com/apps/
2. Create App (Type: Business)
3. Add Instagram Basic Display
4. Get App ID & Secret

**Update Locations:**

**Python (for publishing):**
```bash
# pytho/.env
FACEBOOK_APP_ID=xxxxxxxxxxxxx
FACEBOOK_APP_SECRET=xxxxxxxxxxxxx
FACEBOOK_ACCESS_TOKEN=xxxxxxxxxxxxx
```

**Laravel (for OAuth):**
```bash
# Laravel/.env
INSTAGRAM_CLIENT_ID=xxxxxxxxxxxxx
INSTAGRAM_CLIENT_SECRET=xxxxxxxxxxxxx
INSTAGRAM_REDIRECT_URI=http://localhost:8000/brand/connections/callback/instagram
```

---

#### C. YouTube API Keys

**Kahan se milegi:**
1. Visit: https://console.cloud.google.com/apis/credentials
2. Create Project
3. Enable YouTube Data API v3
4. Create OAuth 2.0 Client ID
5. Download credentials

**Update Locations:**

**Python:**
```bash
# pytho/.env
YOUTUBE_CLIENT_ID=xxxxxxxxxxxxx.apps.googleusercontent.com
YOUTUBE_CLIENT_SECRET=xxxxxxxxxxxxx
YOUTUBE_REFRESH_TOKEN=xxxxxxxxxxxxx
```

**Laravel:**
```bash
# Laravel/.env
YOUTUBE_CLIENT_ID=xxxxxxxxxxxxx.apps.googleusercontent.com
YOUTUBE_CLIENT_SECRET=xxxxxxxxxxxxx
YOUTUBE_REDIRECT_URI=http://localhost:8000/brand/connections/callback/youtube
```

---

#### D. LinkedIn API Keys

**Kahan se milegi:**
1. Visit: https://www.linkedin.com/developers/apps
2. Create App
3. Add Products: "Sign In with LinkedIn" & "Share on LinkedIn"
4. Get Client ID & Secret

**Update Locations:**

**Python:**
```bash
# pytho/.env
LINKEDIN_CLIENT_ID=xxxxxxxxxxxxx
LINKEDIN_CLIENT_SECRET=xxxxxxxxxxxxx
LINKEDIN_ACCESS_TOKEN=xxxxxxxxxxxxx
```

**Laravel:**
```bash
# Laravel/.env
LINKEDIN_CLIENT_ID=xxxxxxxxxxxxx
LINKEDIN_CLIENT_SECRET=xxxxxxxxxxxxx
LINKEDIN_REDIRECT_URI=http://localhost:8000/brand/connections/callback/linkedin
```

---

#### E. TikTok API Keys (Laravel only - for OAuth)

**Kahan se milegi:**
1. Visit: https://developers.tiktok.com/
2. Create App
3. Apply for API access
4. Get Client Key & Secret

**Update Location:**
```bash
# Laravel/.env
TIKTOK_CLIENT_KEY=xxxxxxxxxxxxx
TIKTOK_CLIENT_SECRET=xxxxxxxxxxxxx
TIKTOK_REDIRECT_URI=http://localhost:8000/brand/connections/callback/tiktok
```

---

### 💳 STEP 4: Payment Gateway (Laravel only)

#### Razorpay Keys

**Kahan se milegi:**
1. Visit: https://dashboard.razorpay.com/app/keys
2. Login/Signup
3. Test Mode me keys milenge
4. Live Mode activate karne ke liye KYC complete karein

**Update Location:**
```bash
# Laravel/.env
RAZORPAY_KEY_ID=rzp_test_xxxxxxxxxxxxx
RAZORPAY_KEY_SECRET=xxxxxxxxxxxxx
RAZORPAY_WEBHOOK_SECRET=xxxxxxxxxxxxx
```

---

### 🗄️ STEP 5: Database & Infrastructure (Python me REQUIRED)

#### PostgreSQL Database

**Setup:**
```bash
# Local installation
# OR use Docker:
docker run -d \
  --name postgres \
  -e POSTGRES_USER=aiuser \
  -e POSTGRES_PASSWORD=aipassword \
  -e POSTGRES_DB=ai_microservice \
  -p 5432:5432 \
  postgres:15
```

**Update Location:**
```bash
# pytho/.env
DATABASE_URL=postgresql+asyncpg://aiuser:aipassword@localhost:5432/ai_microservice
```

---

#### Redis Cache

**Setup:**
```bash
# Local installation
# OR use Docker:
docker run -d \
  --name redis \
  -p 6379:6379 \
  redis:7-alpine
```

**Update Location:**
```bash
# pytho/.env
REDIS_URL=redis://localhost:6379/0
CELERY_BROKER_URL=redis://localhost:6379/0
CELERY_RESULT_BACKEND=redis://localhost:6379/1
```

---

### 🔗 STEP 6: Integration URLs

#### Python API URL (Laravel me)

**Update Location:**
```bash
# Laravel/.env
PYTHON_API_URL=http://localhost:8000  # Development
# PYTHON_API_URL=https://api.yourdomain.com  # Production
```

#### Laravel Base URL (Python me)

**Update Location:**
```bash
# pytho/.env
LARAVEL_BASE_URL=http://localhost:8000  # Development
# LARAVEL_BASE_URL=https://yourdomain.com  # Production
```

---

## 🎨 Optional Services

### Vector Store (Python - for RAG features)

#### Weaviate (Cloud)
```bash
# pytho/.env
VECTOR_STORE_TYPE=weaviate
WEAVIATE_URL=https://your-cluster.weaviate.network
WEAVIATE_API_KEY=xxxxxxxxxxxxx
```

**Kahan se milegi:** https://console.weaviate.cloud/

#### FAISS (Local - Default)
```bash
# pytho/.env
VECTOR_STORE_TYPE=faiss
FAISS_INDEX_PATH=./data/faiss_index
```

---

### S3/MinIO Storage (Python - for file storage)

```bash
# pytho/.env
S3_ENDPOINT_URL=http://localhost:9000
S3_ACCESS_KEY=minioadmin
S3_SECRET_KEY=minioadmin
S3_BUCKET_NAME=ai-microservice
```

---

## 📋 Verification Checklist

### ✅ Python Service Check:
```bash
cd pytho
python -c "from config import settings; print('✓ Config loaded')"
```

### ✅ Laravel Config Check:
```bash
cd Laravel
php artisan config:clear
php artisan config:cache
php artisan tinker
>>> config('python.api.base_url')
```

### ✅ Connection Test:
```bash
# Test Python health
curl http://localhost:8000/health/readiness

# Test from Laravel
php artisan tinker
>>> app(\App\Services\PythonApiService::class)->checkHealth()
```

---

## 🚨 Important Notes

### Same Keys (Dono systems me same honi chahiye):
- ✅ `PYTHON_API_KEY` = `LARAVEL_API_KEY`
- ✅ `PYTHON_CALLBACK_SECRET` = `LARAVEL_CALLBACK_SECRET`

### Different Keys (Alag-alag systems me):
- ❌ Social Media OAuth keys (Laravel) ≠ Social Media API keys (Python)
- ❌ OpenAI key (dono me use ho sakti hai, but separate bhi rakh sakte hain)

### Security Best Practices:
1. ✅ Production me strong keys use karein
2. ✅ `.env` files ko `.gitignore` me rakhein
3. ✅ Keys ko environment variables me store karein
4. ✅ Regular rotation karein sensitive keys ka
5. ✅ HTTPS use karein production me

---

## 📞 Troubleshooting

### Common Issues:

**1. "API Key Invalid" Error:**
- Check key spelling
- Verify key is active
- Check rate limits

**2. "Connection Refused" Error:**
- Verify services are running
- Check URLs are correct
- Verify firewall settings

**3. "Signature Verification Failed":**
- Check callback secret matches
- Verify HMAC implementation

---

## 📚 Additional Resources

- **OpenAI Docs:** https://platform.openai.com/docs
- **Anthropic Docs:** https://docs.anthropic.com
- **Twitter API:** https://developer.twitter.com/en/docs
- **Facebook API:** https://developers.facebook.com/docs
- **YouTube API:** https://developers.google.com/youtube/v3
- **LinkedIn API:** https://docs.microsoft.com/en-us/linkedin/
- **Razorpay Docs:** https://razorpay.com/docs/

---

## ✨ Quick Start Commands

```bash
# Generate all security keys at once
echo "SECRET_KEY=$(openssl rand -hex 32)"
echo "ENCRYPTION_KEY=$(openssl rand -hex 16)"
echo "JWT_SECRET=$(openssl rand -hex 32)"
echo "PYTHON_API_KEY=$(openssl rand -hex 24)"
echo "PYTHON_CALLBACK_SECRET=$(openssl rand -hex 32)"
```

Copy output aur paste karein apni `.env` files me! 🚀